
import java.awt.event.KeyEvent;
import java.awt.geom.Ellipse2D;
import java.awt.Rectangle;


public class Player extends GameObject
{
	private double vx;
    private double vy;
    private boolean up,down,left,right;
    private int playerLivesLeft;
    private int bulbGaugeCount;
    private TileMap map;
    private int speedUpTimer;
    private int defenseTimer;
    private PowerUpManager powerUpManager;
    private Ellipse2D.Float boundary;
    private boolean triggerSpeedUp;

    public Player(CircuitConductor cc, TileMap map)
    {
		super(cc);
        this.map = map;
        boundary = new Ellipse2D.Float((int)x,(int)y,(int)width,(int)height);
        setSpriteNames(new String[] {"sparkGlow1.png", "sparkGlow2.png",
                                     "sparkGlow3.png", "sparkGlow4.png",
                                     "sparkGlow5.png", "sparkGlow6.png",
                                     "sparkGlow7.png", "sparkGlow8.png"});
        setAnimationSpeed(10);
        playerLivesLeft = 3;
        bulbGaugeCount = 0;
        powerUpManager = new PowerUpManager(5);
        speedUpTimer = 0;
        defenseTimer = 0;
      }

      public void move()
      {
		  super.move();

          if(!map.xBlocked(this.getX(),this.getY(),this.getVx(),this.getVy(),
                           this.getWidth(),this.getHeight(), this))
          {
			 x += vx;

	      }
	      if(!map.yBlocked(this.getX(),this.getY(),this.getVx(),this.getVy(),
	                       this.getWidth(),this.getHeight()))
	      {
		     y += vy;
	      }

          if(speedUpTimer > 0)
			  speedUpTimer--;
	      else if ((speedUpTimer <= 0) && powerUpManager.speedUpOn())
	      {
			  powerUpManager.speedUpDeactivate(5);
		  }
          if(defenseTimer > 0)
			  defenseTimer--;
	      else if ((defenseTimer <= 0) && powerUpManager.defenseOn())
	      {
			  powerUpManager.defenseDeactivate();
		  }
	  }

      private void updateSpeed()
      {
		  vx=0;
          vy=0;
          if(down)
             vy = powerUpManager.getSpeed();
          if(up)
             vy = -powerUpManager.getSpeed();
          if(left)
             vx = -powerUpManager.getSpeed();
          if(right)
             vx = powerUpManager.getSpeed();
      }

      public void keyReleased(KeyEvent e)
      {
        switch (e.getKeyCode())
        {
			case KeyEvent.VK_DOWN:
			   down = false;
			   break;
            case KeyEvent.VK_UP:
               up = false;
               break;
            case KeyEvent.VK_LEFT:
               left = false;
               break;
            case KeyEvent.VK_RIGHT:
               right = false;
               break;
        }
        updateSpeed();
      }

      public void keyPressed(KeyEvent e)
      {
        switch (e.getKeyCode())
        {
			case KeyEvent.VK_UP:
               up = true;
               break;
          case KeyEvent.VK_LEFT:
               left = true;
               break;
          case KeyEvent.VK_RIGHT:
               right = true;
               break;
          case KeyEvent.VK_DOWN:
               down = true;
               break;

          // if the player has the required bulb gauge amount and
          // is cleared by the PowerUpManager, the selected power-up
          // is activated and the required bulb gauge amount is removed

          // in cases of timed power-ups, timers are initialized to
          // keep track of how long the power-ups should be active.

          case KeyEvent.VK_S:
             double x = map.getCenterXCoordinate(this.getX(),this.getWidth());
             double y = map.getCenterXCoordinate(this.getY(),this.getHeight());

             if(((map.getInTileYCoordinate(y) == (map.getTileSize() / 2)) &&
                ((map.getInTileXCoordinate(x) % 10) == 5)) ||
			    ((map.getInTileXCoordinate(x) == (map.getTileSize() / 2)) &&
			    ((map.getInTileYCoordinate(y) % 10) == 5)))
                speedUp(0);
             else
             {
                speedUp(5);
			 }
             break;
          case KeyEvent.VK_D:
             if((getBulbGaugeCount() >= 4) && !powerUpManager.forceFieldOn() &&
                 !powerUpManager.defenseOn())
		     {
				powerUpManager.defenseActivate();
				cc.getMediaManager().playSoundEffect("defense.wav");
                setBulbGaugeCount(getBulbGaugeCount() - 4);
                defenseTimer = 400;
			 }
             break;
          case KeyEvent.VK_F :
             if((getBulbGaugeCount() >= 6) && !powerUpManager.forceFieldOn() &&
                 !powerUpManager.defenseOn())
             {
				powerUpManager.forceFieldActivate();
				cc.getMediaManager().playSoundEffect("forceField.wav");
                setBulbGaugeCount(getBulbGaugeCount() - 6);
			 }
             break;

        }
        updateSpeed();
      }

      public void speedUp(int offset)
      {
		  if((getBulbGaugeCount() >= 3) && (!powerUpManager.speedUpOn()))
          {
			  powerUpManager.speedUpActivate(10 + offset);
			  cc.getMediaManager().playSoundEffect("speedUp.wav");
              setBulbGaugeCount(getBulbGaugeCount() - 3);
              speedUpTimer = 400;
		  }
	  }

	  public void collision(GameObject inGameObject)
	  {
		  if (inGameObject instanceof BadSpark)
		  {
			 if(powerUpManager.forceFieldOn())
			 {
                powerUpManager.forceFieldDeactivate();
			    cc.getMediaManager().playSoundEffect("sparkDeath.wav");
			    inGameObject.remove();
			 } else if (!powerUpManager.forceFieldOn() &&
			             !powerUpManager.defenseOn() && !this.toBeKilled())
			 {
				this.remove();
				playerLivesLeft = playerLivesLeft - 1;
				cc.getMediaManager().playSoundEffect("playerDeath.wav");
			 }

			 // else if defense is on, do nothing in event of collision

		  }
	  }

	  public void setBounds(int xPos, int yPos, int width, int height)
	  {
		  boundary.setFrame(xPos,yPos,width,height);

      }
	  public Rectangle getBounds()
	  {
		  return boundary.getBounds();
	  }

	  public int getLivesLeft()
	  {
		  return playerLivesLeft;
	  }

	  public void setLivesLeft(int inPlayerLivesLeft)
	  {
		  playerLivesLeft = inPlayerLivesLeft;
	  }

	  public int getBulbGaugeCount()
	  {
		  return bulbGaugeCount;
	  }

	  public void setBulbGaugeCount(int inulbGaugeCount)
	  {
		  bulbGaugeCount = inulbGaugeCount;
	  }

      public double getVx()
      {
		  return vx;
      }
      public void setVx(int inVx)
      {
		  vx = inVx;
	  }

      public double getVy()
      {
		  return vy;
	  }
      public void setVy(int inVy)
      {
		  vy = inVy;
	  }
}